var samplePageObj = {
  // 샘플 타이틀
  title: '머지 기능',
  subtitle: '헤더/데이터 영역의 인접한 셀간에 같은 값이 있는 경우 자동으로 병합 시킬 수 있습니다.',

  // 샘플 설명
  desc: '머지를 하려면 시트의 초기화 과정에서 (Cfg)HeaderMerge,(Cfg)DataMerge 속성을 정의하시거나, setAutoMerge() 함수를 호출하시면 됩니다.',

  // 객체 초기화 구문
  init: {
    Cfg: {
      SearchMode: 2,
      HeaderMerge: 3,
      DataMerge: 3,
      PrevColumnMerge: 3
    },
    LeftCols: [
      {
        Header: [
          'No',
          'No'
        ],
        Name: 'SEQ',
        Type: 'Int',
        Width: 40,
        ColMerge: 0
      },
    ],
    Cols: [
      {
        Header: [
          '분류',
          '대분류'
        ],
        Name: 'cls1',
        Type: 'Text',
        Width: 130,
        Align: 'Center'
      },
      {
        Header: [
          '분류',
          '중분류'
        ],
        Name: 'cls2',
        Type: 'Text',
        Width: 130,
        Align: 'Center'
      },
      {
        Header: [
          '분류',
          '소분류'
        ],
        Name: 'cls3',
        Type: 'Text',
        Width: 130,
        Align: 'Center'
      },
      {
        Header: [
          '제품',
          '제품'
        ],
        Name: 'goods',
        Type: 'Text',
        MinWidth: 200,
        Width: 250,
        Align: 'Left'
      },
      {
        Header: [
          '제품',
          '가격'
        ],
        Name: 'price',
        Type: 'Int',
        Width: 100,
        Format: '#,##0 원'
      },
      {
        Header: [
          '제품',
          '상세설명'
        ],
        Name: 'etc',
        Type: 'Lines',
        MinWidth: 140,
        RelWidth: 1
      },

    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div>'
    + '<label>헤더 머지 조건</label><select id=\'sel2\' class=\'mgr10\'><option value=\'0\' selected>0번 - 병합 안함</option><option value=\'1\'>1번 - 열 기준 병합</option><option value=\'2\'>2번 - 행 기준 병합</option><option value=\'3\'>3번 - 열 우선 병합</option><option value=\'4\'>4번 - 행 우선 병합</option><option value=\'5\'>5번 - 열 우선 사방 병합</option><option value=\'6\'>6번 - 행 우선 사방 병합</option></select><hr>'
    + '<label>데이터 머지 조건</label><select id=\'sel\' class=\'mgr30\'><option value=\'0\' selected>0번 - 병합 안함</option><option value=\'1\'>1번 - 열 기준 병합</option><option value=\'2\'>2번 - 행 기준 병합</option><option value=\'3\'>3번 - 열 우선 병합</option><option value=\'4\'>4번 - 행 우선 병합</option><option value=\'5\'>5번 - 열 우선 사방 병합</option><option value=\'6\'>6번 - 행 우선 사방 병합</option></select><hr>'
    + '<label>앞컬럼 기준</label><select id=\'sel3\' class=\'mgr10\'><option value=\'0\' selected=\'0\'>0번 - 병합 안함</option><option value=\'1\'>1번 - 데이터 영역 병합</option><option value=\'2\'>2번 - 헤더 영역 병합</option><option value=\'3\'>3번 - 데이터/헤더 영역 병합</option></select><hr>'
    + '<button class=\'mainbtn\' onclick=\'sampleBtn(this)\'>적용</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    sheet.setAutoMerge(
      {
        dataMerge: parseInt(document.querySelector('#sel').value, 10),
        headerMerge: parseInt(document.querySelector('#sel2').value, 10),
        prevColumnMerge: parseInt(document.querySelector('#sel3').value, 10)
      }
    );
  },

  // event구문
  event: {
  },

  // data
  data: [
    {
      etc: '그늘막형 / 1룸형 / 5인용 / 방수 / 원터치/팝업 ',
      price: 75910,
      cls3: '그늘막형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '아이두젠 패스트캠프 원터치 텐트 오토 6 착탈식 와이드 익스텐션'
    },
    {
      etc: '그늘막형 / 1룸형 / 4인용~5인용 / 방수 / 원터치/팝업 ',
      price: 47920,
      cls3: '그늘막형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '아이두젠 패스트캠프 원터치 텐트 오토 6'
    },
    {
      etc: '2룸형 / 4인용 / 방수 / 발수 / 방충망 ',
      price: 366440,
      cls3: '2룸형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '비젼코베아 코베아 네스트'
    },
    {
      etc: '2룸형 / 4인용 / 방수 / 발수 / 방충망 ',
      price: 273210,
      cls3: '2룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '비젼코베아 코베아 오토 하우스 M'
    },
    {
      etc: '1룸형 / 5인용~6인용 / 방수 / 원터치/팝업 / 방충망 ',
      price: 91240,
      cls3: '1룸형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '비에프엘 버팔로 프리미엄 뉴 프리마 팝업텐트 세트'
    },
    {
      etc: '1룸형 / 2인용 / 방수 ',
      price: 98690,
      cls3: '1룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '네이처하이크 클라우드 피크 2'
    },
    {
      etc: '4인용~5인용 / 발수 / 방충망 ',
      price: 152190,
      cls3: '4인용',
      cls2: '2룸형',
      cls1: '텐트',
      goods: '카즈미 X1 텐트'
    },
    {
      etc: '2룸형 / 6인용~7인용 / 발수 / 방충망 ',
      price: 207600,
      cls3: '2룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '비에프엘 버팔로 리빙쉘 와이드 돔'
    },
    {
      etc: '차량루프 ',
      price: 654000,
      cls3: '차량루프',
      cls2: '4인용',
      cls1: '텐트',
      goods: '캠핑나루 메세타 루프탑텐트 퍼스트 1900'
    },
    {
      etc: '그늘막형 / 1룸형 / 4인용 / 원터치/팝업 / 방충망 ',
      price: 156330,
      cls3: '그늘막형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '로티캠프 원터치 컴포트 플러스 프리미엄 텐트'
    },
    {
      etc: '2룸형 / 4인용~5인용 ',
      price: 181940,
      cls3: '2룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '콜맨 터프 스크린 2룸 하우스 플러스'
    },
    {
      etc: '2룸형 / 3인용~4인용 / 발수 / 방충망 ',
      price: 50030,
      cls3: '2룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '스노우라인 프라임 디럭스 텐트'
    },
    {
      etc: '2룸형 / 4인용 / 방수 / 발수 ',
      price: 61200,
      cls3: '2룸형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '비젼코베아 코베아 아웃백 4'
    },
    {
      etc: '비박용 / 1룸형 / 2인용~3인용 ',
      price: 560610,
      cls3: '비박용',
      cls2: '돔형',
      cls1: '텐트',
      goods: 'NEMO Equipment, Inc. 니모 다이거 3P'
    },
    {
      etc: '4인용 / 방수 / 발수 / 방충망 ',
      price: 549054,
      cls3: '4인용',
      cls2: '돔형',
      cls1: '텐트',
      goods: '비젼코베아 코베아 이지 돔'
    },
    {
      etc: '1룸형 / 4인용~5인용 / 원터치/팝업 / 방충망 ',
      price: 558500,
      cls3: '1룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '아이두젠 패스트캠프 오토 4 클래식'
    },
    {
      etc: '그늘막형 / 1룸형 / 3인용~4인용 / 원터치/팝업 / 방충망 ',
      price: 506000,
      cls3: '그늘막형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '아이두젠 패스트캠프 원터치 텐트 오페라 베이직 3'
    },
    {
      etc: '그늘막형 / 1룸형 / 7인용~8인용 / 발수 / 방충망 ',
      price: 206330,
      cls3: '그늘막형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '로맨틱아프리카 이지 돔타프 피크닉 구성'
    },
    {
      etc: '그늘막형 / 1룸형 / 6인용 / 방수 / 원터치/팝업 ',
      price: 84550,
      cls3: '그늘막형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '로티캠프 빅스퀘어 텐트'
    },
    {
      etc: '1룸형 / 4인용~5인용 ',
      price: 39890,
      cls3: '1룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '비젼코베아 코베아 리버사이드 4'
    },
    {
      etc: '그늘막형 / 1룸형 / 9인용~10인용 / 원터치/팝업 / 방충망 ',
      price: 93670,
      cls3: '그늘막형',
      cls2: '티피형',
      cls1: '텐트',
      goods: '아이두젠 패스트캠프 티피 텐트'
    },
    {
      etc: '그늘막형 / 1룸형 / 7인용~8인용 / 방수 / 원터치/팝업 / 방충망 ',
      price: 107920,
      cls3: '그늘막형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '아이두젠 패스트캠프 원터치 텐트 마운트프로'
    },
    {
      etc: '1룸형 / 4인용 / 방수 / 발수 / 차량연결 ',
      price: 113050,
      cls3: '1룸형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '비젼코베아 코베아 투어링 카 쉘터 2'
    },
    {
      etc: '2룸형 / 4인용 / 방수 / 발수 ',
      price: 132050,
      cls3: '2룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '비젼코베아 코베아 스페이스 돔 3'
    },
    {
      etc: '2룸형 / 방수 / 발수 ',
      price: 195800,
      cls3: '2룸형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '스노우라인 미라클 패밀리 텐트'
    },
    {
      etc: '1룸형 / 5인용~6인용 / 방수 / 원터치/팝업 / 방충망 ',
      price: 212600,
      cls3: '1룸형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '비에프엘 버팔로 프리미엄 뉴 프리마 팝업텐트'
    },
    {
      etc: '그늘막형 / 1룸형 / 4인용~5인용 / 방수 / 원터치/팝업 / 방충망 ',
      price: 411110,
      cls3: '그늘막형',
      cls2: '터널형',
      cls1: '텐트',
      goods: '아이두젠 패스트캠프 원터치 텐트 오페라 스위트 와이드 착탈익스텐션 플라이프로'
    },
    {
      etc: '4인용~5인용 / 방수 / 원터치/팝업 / 방충망 ',
      price: 479400,
      cls3: '4인용',
      cls2: '터널형',
      cls1: '텐트',
      goods: '아웃팅 조이마스터 팝업 텐트'
    },
    {
      etc: '그늘막형 / 1룸형 / 8인용~10인용 / 방수 / 방충망 / 옥스포드 / 300D ',
      price: 66900,
      cls3: '그늘막형',
      cls2: '돔형',
      cls1: '텐트',
      goods: '캠프라우드 캐노피 텐트'
    },
    {
      etc: '4인용 / 발수 / 원터치/팝업 / 방충망 ',
      price: 70740,
      cls3: '4인용',
      cls2: '돔형',
      cls1: '텐트',
      goods: '스위스알파인클럽 필라투스 원터치 텐트 블랙에디션NEW'
    },
    {
      etc: '말이식(롤형) / 사용인원: 7인용 / 방수 / 재질: 옥스포드원단 / 무게: 320g / 구성품: 전용가방 / 크기(가로x세로): 200x200cm',
      price: 112360,
      cls3: '돗자리',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '2m 방수돗자리 오렌지'
    },
    {
      etc: '전용가방 / 크기(가로x세로x두께): 152x203x25cm',
      price: 132700,
      cls3: '방수',
      cls2: '에어매트',
      cls1: '매트',
      goods: '인텍스 에어매트 듀라빔 베이직 퀸 (152x203)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 4인용 / 구성품: 전용가방, 에어펌프 / 크기(가로x세로x두께): 200x260x20cm / 무게: 15.6kg',
      price: 34320,
      cls3: '에어매트',
      cls2: '텐트내부용',
      cls1: '매트',
      goods: '에어박스 에어매트리스S 20cm (200x260, 특포맨)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 2인용 / 재질: 폴리에스테르 / 구성품: 전용가방 / 크기(가로x세로x두께): 66x186x5cm',
      price: 44900,
      cls3: '자충식매트',
      cls2: '텐트내부용',
      cls1: '매트',
      goods: 'YIERSHENG 황동마개 감성 자충매트 (66x186)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 3인용 / 크기(가로x세로x두께): 187x238x18cm / 무게: 6.8kg',
      price: 73710,
      cls3: '에어매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '비젼코베아 코베아 에어 밸런스 매트 240 (187x238)'
    },
    {
      etc: '접이식(폴딩형) / 사용인원: 8인용 / 방수 / 재질: 폴리에틸렌 / 구성품: 전용가방 / 색상: 블루, 그린, 퍼플 / 크기(가로x세로): 200x240cm',
      price: 77600,
      cls3: '엠보싱매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '씨엔디상사 벨라홈 캠핑매트 특대형 (200x240)'
    },
    {
      etc: '충전재: 폴리에스테르 / 재질: 폴리에스테르 / 무게: 600g / 크기(가로x세로): 72x190cm',
      price: 168780,
      cls3: '사용계절',
      cls2: '사각',
      cls1: '침낭',
      goods: '비젼코베아 코베아 에이드 하계용 침낭'
    },
    {
      etc: '여름용 / 충전재: 오리털 / 무게: 800g / 크기(가로x세로): 75x195cm, 수납크기-16x28cm',
      price: 20410,
      cls3: '사용계절',
      cls2: '사각',
      cls1: '침낭',
      goods: '비젼코베아 코베아 트래블 라이트'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 방수 / 재질: 폴리에스테르 / 무게: 1600g / 구성품: 전용가방, 스트랩 / 크기(가로x세로x두께): 70x190x5cm',
      price: 379980,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '나린 케븐 황동 2구 자충매트 5cm (70x190)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 2인용 / 재질: 폴리에스테르 / 구성품: 전용가방, 스트랩 / 크기(가로x세로x두께): 135x190x5cm',
      price: 19800,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '나리안 케븐 황동 2구 자충매트 2인용 (135x190)'
    },
    {
      etc: '사계절용 / 충전재: 홀로파이버 / 크기(가로x세로): 70x180cm / 무게: 1kg / 색상: 오렌지, 블루',
      price: 72170,
      cls3: '사용계절',
      cls2: '머미',
      cls1: '침낭',
      goods: '카즈미 익스트림 침낭 1'
    },
    {
      etc: '충전재: 폴리에스테르 / 재질: 폴리에스테르 / 무게: 850g / 색상: 네이비, 그린, 레드, 브라운 / 크기(가로x세로): 75x180cm, 수납크기-21x37cm / 구성품: 침낭, 전용가방',
      price: 16200,
      cls3: '사용계절',
      cls2: '사각',
      cls1: '침낭',
      goods: '빈슨메시프 레아 기본형 침낭'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 재질: 폴리에스테르 / 무게: 2.4kg / 구성품: 전용가방, 스트랩 / 크기(가로x세로x두께): 본체-67x180x8cm, 수납크기-18x70cm / 색상: 블랙, 블루 / 구성품: 에어매트, 수납밴드, 수리패치, 수납가방',
      price: 68020,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '조아캠프 인디 프리미엄 2구 자충매트 8T (67x180)'
    },
    {
      etc: '전용가방 / 크기(가로x세로x두께): 99x191x25cm',
      price: 27610,
      cls3: '방수',
      cls2: '에어매트',
      cls1: '매트',
      goods: '인텍스 에어매트 듀라빔 베이직 광폭싱글 (99x191)'
    },
    {
      etc: '전용가방 / 크기(가로x세로x두께): 152x203x25cm',
      price: 54940,
      cls3: '방수',
      cls2: '에어매트',
      cls1: '매트',
      goods: '인텍스 에어매트 듀라빔 플러스 퀸 (152x203)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 2인용 / 방수 / 재질: 폴리에스테르 / 무게: 580g / 크기(가로x세로): 100x150cm',
      price: 12730,
      cls3: '피크닉매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '서흥인터내셔날 엠플러스캠프 룸앤홈 피크닉매트 S (100x150)'
    },
    {
      etc: '접이식(폴딩형) / 사용인원: 5인용 / 재질: 폴리에틸렌 / 무게: 1000g / 구성품: 전용가방 / 크기(가로x세로): 140x200cm',
      price: 30310,
      cls3: '엠보싱매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '파크론 고밀도 25배율 프리미엄 캠핑매트 (140x200)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 무게: 1600g / 구성품: 전용가방, 스트랩 / 색상: 레드, 블루, 옐로우 / 크기(가로x세로x두께): 60x188x5cm',
      price: 11480,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '홀러인터내셔널 일반 황동 자충매트 (60x188)'
    },
    {
      etc: '방수 / 구성품: 전용가방, 에어펌프 / 크기(가로x세로x두께): 152x203x30cm / 내장형 전동펌프 220V',
      price: 75360,
      cls3: '접이식',
      cls2: '에어매트',
      cls1: '매트',
      goods: '인텍스 듀라빔 스탠다드 에어매트 퀸 (152x203)'
    },
    {
      etc: '방수 / 구성품: 전용가방, 에어펌프 / 크기(가로x세로x두께): 99x191x30cm / 내장형 전동펌프 220V',
      price: 55190,
      cls3: '접이식',
      cls2: '에어매트',
      cls1: '매트',
      goods: '인텍스 듀라빔 스탠다드 에어매트 광폭 싱글 (99x191)'
    },
    {
      etc: '접이식(폴딩형) / 사용인원: 8인용 / 재질: 폴리에스테르 / 무게: 1800g / 구성품: 전용가방 / 크기(가로x세로x두께): 240x180x2cm',
      price: 27300,
      cls3: '엠보싱매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '파크론 고밀도 25배율 자이언트 캠핑매트 (180x240)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 방수 / 무게: 2000g / 구성품: 전용가방, 스트랩 / 크기(가로x세로x두께): 65x200x5cm',
      price: 53590,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '비제이글로벌 스위스클럽 자동충전 에어 쿨매트 (65x200)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 5인용 / 무게: 4600g / 크기(가로x세로x두께): 152x203x22cm / 내하중: 273kg',
      price: 17900,
      cls3: '에어매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '인텍스 블루 퀸 에어매트 (152x203)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 방수 / 재질: 폴리에스테르 / 무게: 4.5kg / 구성품: 스트랩 / 크기(가로x세로x두께): 136x196x5cm',
      price: 59760,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '파크론 클라우드 캠핑매트 트윈 (136x196, 에스닉)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 방수 / 재질: 폴리에스테르 / 무게: 2750g / 구성품: 전용가방, 스트랩 / 크기(가로x세로x두께): 70x190x8cm',
      price: 31120,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '나린 케븐 황동 2구 자충매트 8cm (70x190)'
    },
    {
      etc: '충전재: 폴리에스테르 / 내한온도: 5℃ / 무게: 1.4kg / 크기(가로x세로): 85x190cm',
      price: 27480,
      cls3: '사용계절',
      cls2: '사각',
      cls1: '침낭',
      goods: '비젼코베아 코베아 트로피칼 800'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 방수 / 재질: 폴리에스테르 / 무게: 1730g / 구성품: 전용가방, 스트랩 / 크기(가로x세로x두께): 65x190x5cm',
      price: 32460,
      cls3: '자충식매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '노마드 뉴 인디언 황동 2구 자충매트 싱글 (65x190)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 2인용 / 무게: 1000g / 크기(가로x세로x두께): 본체-120x200x6.5cm, 수납크기-12x30cm / 색상: 블루, 오렌지 / 구성품: 에어매트, 펌프백, 전용가방',
      price: 86460,
      cls3: '에어매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '네이처하이크 NH 더블 에어매트 6.5 (120x200)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 8인용 / 방수 / 재질: 폴리에틸렌 / 무게: 800g / 구성품: 전용가방 / 크기(가로x세로): 180x240cm',
      price: 27590,
      cls3: '피크닉매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '파크론 에스닉 콤비 다용도 돗자리 대 (180x240)'
    },
    {
      etc: '말이식(롤형) / 사용인원: 1인용 / 구성품: 전용가방, 스트랩 / 크기(가로x세로x두께): 120x193x5cm / 무게: 4kg',
      price: 84250,
      cls3: '에어매트',
      cls2: '텐트내부+아웃도어용',
      cls1: '매트',
      goods: '스패로우 더블 자충매트 (120x193)'
    },
    {
      etc: '팔걸이 / 등받이 / 포켓 / 컴팩트접이식 / 무게: 3.9kg / 내하중: 90kg / 크기(가로x세로x높이): 설치시-47x45x101cm, 수납시-120cm',
      price: 48300,
      cls3: '알루미늄',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '마추픽추 롱 릴렉스 체어 세트 (2개)'
    },
    {
      etc: '팔걸이 / 등받이 / 포켓 / 컴팩트접이식 / 무게: 2.8kg / 내하중: 100kg / 크기(가로x세로x높이): 설치시-53.5x53x94.5cm, 수납시-14x15x112cm',
      price: 48050,
      cls3: '알루미늄',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '넘버엔 릴렉스 체어 프로 세트 (2개)'
    },
    {
      etc: '폴딩 / 높이조절: 3단 / 대나무 상판 / 프레임재질: 알루미늄 / 무게: 5.8kg / 크기(가로x세로x높이): 65x100x42,50,70cm',
      price: 106170,
      cls3: '알루미늄',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '비젼코베아 코베아 AL 밤부 원액션 테이블 L'
    },
    {
      etc: '무게: 7.4kg / 크기(가로x세로x높이): 특대형의자-90x50x90cm, 소형의자-37x37x57cm, 테이블-48x48x34cm / 무게: 특대형의자-2.5kg, 소형의자-1.3kg, 테이블-1.1kg / 구성품: 특대형 의자 2개,소형 의자 1개,테이블 1개,보관가방 1개',
      price: 26550,
      cls3: '복합소재',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '디에스캠프 캠핑 의자 테이블 5종세트'
    },
    {
      etc: '등받이 / 분해접이식 / 무게: 860g / 내하중: 145kg / 크기(가로x높이): 설치시-55x65cm, 수납시-34x11cm',
      price: 19280,
      cls3: '두랄루민',
      cls2: '경량의자',
      cls1: '캠핑가구',
      goods: '코코아이티 초경량 체어 기본형'
    },
    {
      etc: '2단 / 알루미늄 상판 / 무게: 4.23kg / 크기(가로x세로x높이): 89x51.5x63cm / 구성품: 테이블, 수납가방',
      price: 34640,
      cls3: '알루미늄',
      cls2: '롤테이블',
      cls1: '캠핑가구',
      goods: '커스커즈 알루미늄 롤 테이블'
    },
    {
      etc: '2폴딩 / 높이조절: 2단 / 합판 / 프레임재질: 알루미늄 / 무게: 4.95kg / 크기(가로x세로x높이): 120x60x70.5cm / 내하중: 30kg',
      price: 44990,
      cls3: '복합소재',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '비젼코베아 코베아 KECV9FM-03 2폴딩 테이블'
    },
    {
      etc: '팔걸이 / 등받이 / 포켓 / 컴팩트접이식 / 무게: 3kg / 내하중: 100kg / 크기(가로x세로x높이): 설치시-58x70x100cm, 수납시-117x15x16cm / 색상: 블루, 오렌지',
      price: 45190,
      cls3: '알루미늄',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '비젼코베아 코베아 필드 릴렉스 롱 체어 2 (1개)'
    },
    {
      etc: '팔걸이 / 등받이 / 컴팩트접이식 / 무게: 3.6kg / 내하중: 100kg / 크기(가로x세로x높이): 설치시-48x37x95cm, 수납시-20x112x15cm / 색상: 블랙, 레드, 그레이',
      price: 89000,
      cls3: '알루미늄',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '홀리데이 롱 로우 체어'
    },
    {
      etc: '2폴딩 / 프레임재질: 알루미늄 / 무게: 1.4kg / 색상: 오크, 그린 / 크기(가로x세로x높이): 61x41x27cm',
      price: 9890,
      cls3: '복합소재',
      cls2: '미니테이블',
      cls1: '캠핑가구',
      goods: '이세이브 접이식 폴딩 2단 미니 테이블'
    },
    {
      etc: '무게: 4kg / 크기(가로x세로x높이): 90x53x70cm',
      price: 59000,
      cls3: '알루미늄',
      cls2: '롤테이블',
      cls1: '캠핑가구',
      goods: '캠피스트 오토레그 테이블 90'
    },
    {
      etc: '팔걸이 / 등받이 / 목받침 / 포켓 / 컴팩트접이식 / 무게: 3.5kg / 내하중: 80kg / 크기(가로x세로x높이): 설치시-53.5x57x100cm, 수납시-19x125cm / 색상: 그레이, 블랙, 와인',
      price: 50410,
      cls3: '알루미늄',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '카즈미 플러스 릴렉스 체어'
    },
    {
      etc: '등받이 / 포켓 / 컴팩트접이식 / 무게: 1.9kg / 내하중: 80kg / 크기(가로x세로x높이): 설치시-38x38x58cm, 수납시-12.5x60cm',
      price: 12590,
      cls3: '스틸',
      cls2: '미니의자',
      cls1: '캠핑가구',
      goods: '카즈미 시그니처 카롤 체어'
    },
    {
      etc: '팔걸이 / 등받이 / 컵홀더 / 포켓 / 컴팩트접이식 / 무게: 3kg / 내하중: 100kg / 크기(가로x세로x높이): 설치시-81x50x91cm, 수납시-91x15x15cm',
      price: 20490,
      cls3: '스틸',
      cls2: '일반의자',
      cls1: '캠핑가구',
      goods: '비젼코베아 코베아 하이백 체어 2'
    },
    {
      etc: '팔걸이 / 등받이 / 포켓 / 컴팩트접이식 / 무게: 3.9kg / 내하중: 90kg / 크기(가로x세로x높이): 설치시-47x46x92cm, 수납시-110cm / 색상: 브라운, 네이비, 레드, 스카이블루',
      price: 44210,
      cls3: '알루미늄',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '마추픽추 릴렉스 체어 세트 (2개)'
    },
    {
      etc: '2폴딩 / 합판 / 프레임재질: 알루미늄 / 무게: 1.3kg / 크기(가로x세로x높이): 61x40.5x25.5cm',
      price: 8960,
      cls3: '알루미늄',
      cls2: '미니테이블',
      cls1: '캠핑가구',
      goods: '캠프타임 미니 접이식 테이블 (네이쳐)'
    },
    {
      etc: '3단 / 무게: 4.7kg / 구성품: 테이블+의자 4개 / 크기(가로x세로x높이): 테이블-120x60x55,61,70cm, 의자-32x28x34cm / 무게: 의자-620g',
      price: 24400,
      cls3: '복합소재',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '카르닉 피크닉 폴딩 테이블'
    },
    {
      etc: '팔걸이 / 등받이 / 폴더접이식 / 무게: 2.1kg / 내하중: 80kg / 크기(가로x세로x높이): 설치시-54x55x60.5cm, 수납시-54x55.5x8.5cm',
      price: 43100,
      cls3: '알루미늄',
      cls2: '미니의자',
      cls1: '캠핑가구',
      goods: '콜맨 컴팩트 폴딩 체어 (네이비)'
    },
    {
      etc: '프레임재질: 스틸 / 무게: 7.6kg / 크기(가로x세로x높이): 12.2x60x74cm',
      price: 27920,
      cls3: '플라스틱',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '상도가구 아웃인 브로몰딩1200 접이식 테이블 (다크그레이)'
    },
    {
      etc: '의자-49x47x89cm, 테이블-47x47x37cm / 색상: 네이비, 브라운',
      price: 24460,
      cls3: '복합소재',
      cls2: '테이블세트',
      cls1: '캠핑가구',
      goods: '조아캠프 트래블 5종 세트'
    },
    {
      etc: '등받이 / 분해접이식 / 무게: 890g / 내하중: 145kg / 크기(가로x높이): 설치시-52x66cm, 수납시-35x12cm',
      price: 85490,
      cls3: '알루미늄',
      cls2: '경량의자',
      cls1: '캠핑가구',
      goods: 'DAC (주) 헬리녹스 체어원 (블랙)'
    },
    {
      etc: '팔걸이 / 등받이 / 포켓 / 컴팩트접이식 / 무게: 2.6kg / 내하중: 80kg / 크기(가로x세로x높이): 설치시-41.5x36x68cm, 수납시-13x84cm / 색상: 그레이, 와인',
      price: 36030,
      cls3: '알루미늄',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '카즈미 럭셔리 미니 릴렉스 체어'
    },
    {
      etc: '팔걸이 / 등받이 / 포켓 / 컴팩트접이식 / 무게: 4.7kg / 내하중: 100kg / 크기(가로x세로x높이): 설치시-62x72x103cm, 수납시-117x14x15cm',
      price: 77600,
      cls3: '스틸',
      cls2: '릴렉스의자',
      cls1: '캠핑가구',
      goods: '비젼코베아 코베아 레이백 체어 3 (2개)'
    },
    {
      etc: '4폴딩 / 높이조절: 3단 / 합판 / 프레임재질: 알루미늄 / 무게: 8.3kg / 크기(가로x세로x높이): 80x160x30,40,66cm / 구성품: 테이블 본체, 랜턴걸이, 높이조절 다리, 기본다리, 수납가방',
      price: 94910,
      cls3: '알루미늄',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '아베나키 알루미늄 4폴딩 테이블 블랙에디션'
    },
    {
      etc: '등받이 / 분해접이식 / 무게: 1.1kg / 내하중: 150kg / 크기(가로x세로x높이): 설치시-49x51x65cm, 수납시-37x10x10cm / 색상: 버건디, 블랙, 카키',
      price: 102230,
      cls3: '알루미늄',
      cls2: '경량의자',
      cls1: '캠핑가구',
      goods: '비젼코베아 코베아 2017 비비드 체어 (2개)'
    },
    {
      etc: '포켓 / 각도조절 / 폴더접이식 / 무게: 700g / 내하중: 80kg / 크기(가로x세로x높이): 설치시-40x40x40cm, 수납시-39x15cm',
      price: 16320,
      cls3: '복합소재',
      cls2: '그라운드체어',
      cls1: '캠핑가구',
      goods: '비젼코베아 코베아 그라운드 체어 2'
    },
    {
      etc: '무게: 1.7kg / 크기(가로x세로x높이): 82.5x36x33cm / 내하중: 10kg / 구성품: 테이블 상판, 테이블 프레임, 메쉬망, 캐리백',
      price: 67420,
      cls3: '알루미늄',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '카즈미 NEW IMS 6'
    },
    {
      etc: '등받이 / 분해접이식 / 무게: 910g / 크기(가로x높이): 설치시-51x65cm, 수납시-13x43x9cm',
      price: 40870,
      cls3: '알루미늄',
      cls2: '경량의자',
      cls1: '캠핑가구',
      goods: '제드코리아(주) 파티오 체어'
    },
    {
      etc: '프레임재질: 알루미늄 / 무게: 725g / 크기(가로x세로x높이): 56x40x38cm / 내하중: 20kg',
      price: 29000,
      cls3: '알루미늄',
      cls2: '롤테이블',
      cls1: '캠핑가구',
      goods: '캠토리 트레킹 백패킹 경량 알루미늄 롤테이블'
    },
    {
      etc: '프레임재질: 알루미늄 / 무게: 8.45kg / 크기(가로x세로x높이): 134x86x66cm',
      price: 71680,
      cls3: '알루미늄',
      cls2: '테이블',
      cls1: '캠핑가구',
      goods: '휴대용 테이블 4인 세트'
    }
  ]
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
